﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodUsersView : BaseAPIMethod
        {

            public MethodUsersView(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "usersview"; }
            }

            private string _user_email = null;
            protected override void DoReadRequestParams()
            {
                _user_email = Component.APIRequestParams["user_email"];
            }

            /// <summary>
            /// Tutaj musimy nadpisac walidacje bazowa, bo nie ma sesji
            /// wiec sprawdzamy tylko czy sa parametry w URLu wlasciwe
            /// </summary>
            /// <returns></returns>
            protected override bool IsValid()
            {
                return DoValidate();
            }

            protected override bool DoValidate()
            {
                if (!string.IsNullOrEmpty(_user_email))
                {
                    return true;
                }
                AddErrorMessage("Nie podano adresu email.");
                return false;
            }

            protected override GResponseData DoGetGResponseData()
            {
                GUsersView _GUsersView = Component.BLELearning.APIMobile.GetGUser(_user_email);
                if (_GUsersView != null)
                {
                    StatusCode = StatusCodeType.OK;
                    return new GResponseData_InnerData() { InnerData = _GUsersView };
                }
                else
                {
                    AddErrorMessage("Nie znaleziono użytkownika dla podanego adresu email.");
                    StatusCode = StatusCodeType.NotFound;
                }
                return null;
            }
        }
    }
}